using UnityEngine;
using System.Collections;
using System.Runtime.InteropServices;

namespace hiveAdiz
{
	public class AdizAppOpen
	{

		private static AdizAppOpen instance = null;

		private AdizAppOpen() {}

		~AdizAppOpen() {
			//
		}

		private string adKey = "";

		public static AdizAppOpen Initialize(AdEventHandlers handler) {

			string defaultKey = AdizCallbackManager.defaultAppOpenKey;
			if(string.IsNullOrEmpty(defaultKey)) { 
				AdizLogger.d("adKey is null or empty.");
				return null; 
			}

			instance = new AdizAppOpen();
			instance.internalInit(defaultKey, handler);
			return instance;
		}

		public static AdizAppOpen Initialize(string hiveAdKey, AdEventHandlers handler) {

			if(string.IsNullOrEmpty(hiveAdKey)) { 
				AdizLogger.d("adKey is null or empty.");
				return null; 
			}

			instance = new AdizAppOpen();
			instance.internalInit(hiveAdKey, handler);
			return instance;
		}

		public static AdizAppOpen InitializeWithPlacementId(string placementId, AdEventHandlers handler) {

			if(string.IsNullOrEmpty(placementId)) { 
				AdizLogger.d("placementId is null or empty.");
				return null; 
			}

			string hiveAdKey = AdizUnityNativeCaller.Instance.GetHiveAdKeyFromPlacementId(placementId);
			if(string.IsNullOrEmpty(hiveAdKey)) { 
				AdizLogger.d("placementId is invalid");
				return null; 
			}

			instance = new AdizAppOpen();
			instance.internalInit(hiveAdKey, handler);
			return instance;
		}

		private void release() {
			if(AdizCallbackManager.callbackHandler.ContainsKey(adKey)) {
				AdizCallbackManager.callbackHandler.Remove(adKey);	
			}

			instance = null;
		}
		
	#if UNITY_ANDROID && !UNITY_EDITOR
		
		private AndroidJavaObject currentActivity = null;
		private AndroidJavaObject hiveAdizPlugin = null;

		private void internalInit(string hiveAdKey, AdEventHandlers handler) {
			AdizLogger.d("AdizAppOpen Init "+hiveAdKey);

			AndroidJavaClass jc = new AndroidJavaClass("com.unity3d.player.UnityPlayer");
			currentActivity = jc.GetStatic<AndroidJavaObject>("currentActivity");
			hiveAdizPlugin = new AndroidJavaObject("com.hive.adiz.plugin.AdizUnityAppOpen");

			adKey = hiveAdKey;
			hiveAdizPlugin.Call("initialize", currentActivity, hiveAdKey);
			
			if(AdizCallbackManager.callbackHandler.ContainsKey(hiveAdKey)) {
				AdizCallbackManager.callbackHandler.Remove(hiveAdKey);	
			}
			AdizCallbackManager.callbackHandler.Add(hiveAdKey, handler);
		}

		public void Load() {
			AdizLogger.d("AdizAppOpen Load");
			hiveAdizPlugin.Call("load");
		}

		public void Destroy() {
			hiveAdizPlugin.Call("destroy");
			release();
		}

		public bool IsInitialized() {
			return hiveAdizPlugin.Call<bool>("isInitialized");
		}

		public bool IsLoaded() {
			return hiveAdizPlugin.Call<bool>("isLoaded");
		}

	#elif UNITY_IOS && !UNITY_EDITOR

		[DllImport("__Internal")]
		private static extern void Adiz_AppOpenInitialize(string hiveAdKey);

		[DllImport("__Internal")]
		private static extern void Adiz_AppOpenLoad(string hiveAdKey);

		[DllImport("__Internal")]
		private static extern void Adiz_AppOpenDestroy(string hiveAdKey);

		[DllImport("__Internal")]
		private static extern bool Adiz_AppOpenIsInitialized(string hiveAdKey);

		[DllImport("__Internal")]
		private static extern bool Adiz_AppOpenIsLoaded(string hiveAdKey);

		private void internalInit(string hiveAdKey, AdEventHandlers handler) {
			AdizLogger.d("AdizAppOpen Init "+hiveAdKey);
			adKey = hiveAdKey;
			
			if(AdizCallbackManager.callbackHandler.ContainsKey(hiveAdKey)) {
				AdizCallbackManager.callbackHandler.Remove(hiveAdKey);	
			}
			AdizCallbackManager.callbackHandler.Add(hiveAdKey, handler);

			Adiz_AppOpenInitialize(hiveAdKey);
		}

		public void Load() {
			AdizLogger.d("AdizAppOpen Load");
			Adiz_AppOpenLoad(adKey);
		}

		public void Destroy() {
			AdizLogger.d("AdizAppOpen Destroy");
			Adiz_AppOpenDestroy(adKey);
			release();
		}

		public bool IsInitialized() {
			return Adiz_AppOpenIsInitialized(adKey);
		}

		public bool IsLoaded() {
			return Adiz_AppOpenIsLoaded(adKey);
		}
	#else

		private void internalInit(string hiveAdKey, AdEventHandlers handler) {
			
		}

		public void Load() {
			
		}		

		public void Destroy() {
			
		}
		
		public bool IsInitialized() {
			return false;
		}

		public bool IsLoaded() {
			return false;
		}
	#endif
		
	}
}